<?php
/**
 * Template Loader
 * Decides which theme to load
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Extract data for templates
$products = isset($table_data['products']) ? $table_data['products'] : array();
$features = isset($table_data['features']) ? $table_data['features'] : array();
$settings = isset($table_data['settings']) ? $table_data['settings'] : array();

// Default to 'simple' if not set
$theme = isset($settings['theme']) ? $settings['theme'] : 'simple';

// Security check: allowlist from registered themes
$allowed_themes = ['simple', 'professional', 'modern']; // Default fallback
if (method_exists($this, 'get_available_themes')) {
    $allowed_themes = array_keys($this->get_available_themes());
}

if (!in_array($theme, $allowed_themes)) {
    $theme = 'simple';
}

// Wrapper class for CSS scoping
$wrapper_class = 'pct-theme-' . $theme;
$accent_color = isset($settings['accent_color']) ? $settings['accent_color'] : '#007bff';
$highlight_color = isset($settings['highlight_color']) ? $settings['highlight_color'] : '#28a745';
?>
<div class="pct-comparison-table <?php echo esc_attr($wrapper_class); ?>"
    id="pct-table-<?php echo esc_attr($table_id); ?>"
    style="--accent-color: <?php echo esc_attr($accent_color); ?>; --highlight-color: <?php echo esc_attr($highlight_color); ?>;">
    <?php
    // Load the specific theme template
    // We pass variables like $products, $features, $settings to it automatically
    // because include shares scope.
    $default_theme_file = plugin_dir_path(__FILE__) . 'themes/' . $theme . '.php';

    // Allow plugins to modify the template path (e.g., for Pro themes)
    $theme_file = apply_filters('pct_theme_template_path', $default_theme_file, $theme);

    if (file_exists($theme_file)) {
        include $theme_file;
    } else {
        echo '<p>Error: Theme file not found.</p>';
    }
    ?>
</div>