<?php
/**
 * Price Comparison Table Template - Professional Theme
 * 
 * Available variables:
 * $table_data - Array containing products, features, and settings
 * $products, $features, $settings - Extracted variables
 */

if (!defined('ABSPATH'))
    exit;
?>

<?php
// Settings check - Robust Boolean Logic
$show_sidebar = !isset($settings['show_sidebar']) || filter_var($settings['show_sidebar'], FILTER_VALIDATE_BOOLEAN);
?>

<!-- Desktop Table View -->
<div class="pct-table-desktop pct-theme-professional-layout">
    <table class="pct-table">
        <thead>
            <tr>
                <?php if ($show_sidebar): ?>
                    <th class="pct-feature-col"></th>
                <?php endif; ?>
                <?php foreach ($products as $product): ?>
                    <th class="pct-product-col <?php echo $product['highlighted'] ? 'pct-highlighted' : ''; ?>">
                        <?php if (!empty($product['badge'])): ?>
                            <span class="pct-badge">
                                <?php echo esc_html($product['badge']); ?>
                            </span>
                        <?php endif; ?>
                        <div class="pct-product-name">
                            <?php echo esc_html($product['name']); ?>
                        </div>
                        <div class="pct-product-price">
                            <?php echo esc_html($product['price']); ?>
                        </div>
                    </th>
                <?php endforeach; ?>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($features as $feature_index => $feature): ?>
                <tr class="pct-feature-row">
                    <?php if ($show_sidebar): ?>
                        <td class="pct-feature-name">
                            <?php echo esc_html($feature['name']); ?>
                        </td>
                    <?php endif; ?>

                    <?php foreach ($products as $i => $product): ?>
                        <?php
                        $feature_id = $feature['id'];
                        $value = isset($product['features'][$feature_id]) ? $product['features'][$feature_id] : '';
                        $is_highlighted = isset($product['highlighted']) && $product['highlighted'];
                        ?>
                        <td class="pct-feature-value <?php echo $is_highlighted ? 'pct-highlighted' : ''; ?>">
                            <?php
                            if (isset($feature['type']) && $feature['type'] === 'bool') {
                                // Boolean rendering
                                $is_true = ($value === 'true' || $value === true || $value === '1');
                                if ($is_true) {
                                    echo '<span class="pct-icon-check" title="Yes">✓</span>';
                                } else {
                                    echo '<span class="pct-icon-cross" title="No">✗</span>';
                                }
                            } else {
                                // Text rendering
                                echo esc_html($value);
                            }
                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
            <tr class="pct-button-row">
                <?php if ($show_sidebar): ?>
                    <td></td>
                <?php endif; ?>
                <?php foreach ($products as $product): ?>
                    <td class="<?php echo $product['highlighted'] ? 'pct-highlighted' : ''; ?>">
                        <a href="<?php echo esc_url($product['button_link']); ?>"
                            class="pct-button <?php echo $product['highlighted'] ? 'pct-button-highlight' : ''; ?>"
                            target="_blank" rel="nofollow noopener">
                            <?php echo esc_html($product['button_text']); ?>
                        </a>
                    </td>
                <?php endforeach; ?>
            </tr>
        </tbody>
    </table>
</div>

<!-- Mobile Card View -->
<div class="pct-table-mobile">
    <?php
    // Sort products to show highlighted first
    $sorted_products = $products;
    usort($sorted_products, function ($a, $b) {
        return $b['highlighted'] - $a['highlighted'];
    });

    foreach ($sorted_products as $product):
        ?>
        <div class="pct-card <?php echo $product['highlighted'] ? 'pct-card-highlighted' : ''; ?>">
            <?php if (!empty($product['badge'])): ?>
                <span class="pct-badge">
                    <?php echo esc_html($product['badge']); ?>
                </span>
            <?php endif; ?>

            <div class="pct-card-header">
                <h3 class="pct-product-name">
                    <?php echo esc_html($product['name']); ?>
                </h3>
                <div class="pct-product-price">
                    <?php echo esc_html($product['price']); ?>
                </div>
            </div>

            <div class="pct-card-features">
                <?php foreach ($features as $feature): ?>
                    <div class="pct-card-feature">
                        <?php if ($show_sidebar): ?>
                            <span class="pct-feature-label">
                                <?php echo esc_html($feature['name']); ?>:
                            </span>
                        <?php endif; ?>
                        <span class="pct-feature-value">
                            <?php
                            $value = isset($product['features'][$feature['id']]) ? $product['features'][$feature['id']] : '';

                            // Fix for bool distinct in mobile too
                            if (isset($feature['type']) && $feature['type'] === 'bool') {
                                $is_true = ($value === 'true' || $value === true || $value === '1');
                                if ($is_true) {
                                    echo '<span class="pct-icon-check">✓</span>';
                                } else {
                                    echo '<span class="pct-icon-cross">✗</span>';
                                }
                            } else {
                                echo wp_kses_post($value);
                            }
                            ?>
                        </span>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="pct-card-footer">
                <a href="<?php echo esc_url($product['button_link']); ?>"
                    class="pct-button <?php echo $product['highlighted'] ? 'pct-button-highlight' : ''; ?>" target="_blank"
                    rel="nofollow noopener">
                    <?php echo esc_html($product['button_text']); ?>
                </a>
            </div>
        </div>
    <?php endforeach; ?>
</div>